#!/usr/bin/perl

# resources2rdf.pl - a script to output an RDF file containing all your MyLibrary resources

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-12 - added pod
# 2004-10-11 - munged location
# 2003-09-23 - first cut; first script using new (half-baked) OOP MyLibrary module

=head1 NAME

resources2rdf.pl - output the all the resource records of a MyLibrary database to RDF

=head1 DESCRIPTION

The program just gets all the resources in a MyLibrary database and outputs each resources' title, description, and location values to STDOUT in the form of a generic RDF file. It is good for dumping your content to an easily-readable format enabling input into something else.

=head1 AUTHOR

Eric Lease Morgan

=cut


# use the necessary modules
use lib '../lib/';
use MyLibrary::Resource;
use strict;

# start the XML/RDF
print qq|<?xml version="1.0"?>\n|;
print qq|<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"\n|;
print qq|xmlns:dc="http://purl.org/dc/elements/1.1/">\n|;

# get all resources
my @resources = MyLibrary::Resource->get_resources(sort => 'name');

# process each resource
foreach my $r (@resources) {

	# get values and escape ampersands
	my $name = $r->name(); $name =~ s/&/&amp;/g;
	my $note = $r->note(); $note =~ s/&/&amp;/g;
	my @locations = MyLibrary::Resource::Location->get_locations(id => $r->id);
	my $url = $locations[0]->location; $url =~ s/&/&amp;/g;
	
	# print this record
	print qq|\t<rdf:Description rdf:about="$url">\n|;
	print qq|\t\t<dc:title>$name</dc:title>\n|;
	print qq|\t\t<dc:description>$note</dc:description>\n|;
	print qq|\t</rdf:Description>\n\n|;
	
}

# end the XML/RDF
print qq|</rdf:RDF>\n|;