package MyLibrary::Portal;

# a set of common routines for implementing a portal using MyLibrary

# Eric Lease Morgan <emorgan@nd.edu>
# 2006-02-15 - first cut

use strict;


sub escape {

    my $text = shift;
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    return($text);
    
}


sub compare_arrays {

	my ($first, $second) = @_;
	no warnings;  # silence spurious -w undef complaints
	return 0 unless @$first == @$second;
	for (my $i = 0; $i < @$first; $i++) { return 0 if $first->[$i] ne $second->[$i] }
	
	return 1;
	
}  


sub remove_duplicates {

  my @list = @_;
  my %seen = ();
  return grep { ! $seen{$_} ++ } @list;

}

# return true or die
1;