<?xml version='1.0'?>
<xsl:stylesheet xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:srw_dc="info:srw/schema/1/dc-v1.1" xmlns:srw="http://www.loc.gov/zing/srw/" xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

<!-- 

  sru2html.xsl
  
  This is an XSL stylesheet. It is used to transform the SRU
  search results into an ordered HTML list. Edit this file
  to change how your search results appear. The output of this
  stylesheet get substituted for the RESULTS token of the
  etc/search.txt template.
  
-->
    <xsl:output method='html' omit-xml-declaration='yes' />
    
    <!-- let's get started -->
    <xsl:template match='/'>
                
		<!-- echo the query and number of hits returned -->
		<p>
			<xsl:text>Your search (</xsl:text>
			<xsl:value-of select='srw:searchRetrieveResponse/srw:echoedSearchRetrieveRequest/srw:query' />
			<xsl:text>) matched </xsl:text>
			<xsl:value-of select='srw:searchRetrieveResponse/srw:numberOfRecords' />
			<xsl:text> record(s).</xsl:text>
		</p>
		
		<!-- list the records -->
		<ol>
			<xsl:for-each select='//srw_dc:dc'>
				<li class='record'>
					<a>
						<xsl:attribute name='href'>
							<xsl:value-of select='dc:identifier' />
						</xsl:attribute>
						<xsl:value-of select='dc:title' />
					</a>
					<xsl:text> - </xsl:text>
					<xsl:value-of select='dc:description' />
				</li>
			</xsl:for-each>
		</ol>
		
    </xsl:template>
    
</xsl:stylesheet>
