#!/usr/bin/perl

# patrons.cgi - create and maintain MyLibrary patrons

# Eric Lease Morgan <emorgan@nd.edu>
# February 7, 2006 - Just beginning


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use strict;
use MyLibrary::Core;
use MyLibrary::Portal;
require 'etc/subroutines.pl';

use constant STYLESHEETID => 1;

# initialize two global variables
my $cgi = CGI->new;
my $html = '';

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')  { &create }
elsif ($cgi->param('cmd') eq 'find')    { &find }
elsif ($cgi->param('cmd') eq 'edit')    { &edit }
elsif ($cgi->param('cmd') eq 'delete')  { &delete }
else { $html = $cgi->p("Unknown command. Call Eric.") }

# quit
&gracefulExit;


#############
# subroutines

sub header {
	
	# get the value of this script
	my $script = $cgi->script_name;

	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Patrons</title>
		<link rel='stylesheet' href='../etc/portal-screen.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="admin.cgi">Home</a></li>
				<li><a href="facets.cgi">Facets</a></li>
				<li><a href="terms.cgi">Terms</a></li>
				<li><a href="location-types.cgi">Location types</a></li>
				<li><a href="resources.cgi">Resources</a></li>
				<li><a href="patrons.cgi" id="current">Patrons</a></li>
			</ul>
		</div>
	
	<div class='menu'>
		<p><b><a href="$script">Manage patrons</a></b></p>
		<a href="$script?cmd=create">Create</a><br />
		<a href="$script?cmd=find">Find all</a><br />
		<a href="$script?cmd=edit">Edit</a><br />
		<a href="$script?cmd=delete">Delete</a><br />
		<br />
	</div>
	<div class='content'>
EOH

}


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage patrons');
	$html .= $cgi->p('Use these pages to manage MyLibrary Portal patrons.');

}

sub create {

	# build a list of terms
	my @term_names;
	foreach (MyLibrary::Term->get_terms(sort => 'name')) { push @term_names, $_->term_name }
	
	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# build the form
		$html .= $cgi->p('Use this form to create a patron.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['First name',      $cgi->textfield(-name => 'firstname')]),
							td(['Last name',       $cgi->textfield(-name => 'surname')]),
							td(['Email',           $cgi->textfield(-name => 'email')]),
							td(['Terms',           $cgi->scrolling_list(-name => 'term_names', -values => [@term_names], -multiple => 'true')]),
							td([''    ,       $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $patron = MyLibrary::Patron->new;
    	$patron->patron_firstname($cgi->param('firstname'));
    	$patron->patron_surname($cgi->param('surname'));
    	$patron->patron_email($cgi->param('email'));
    	$patron->patron_stylesheet_id(STYLESHEETID);
    	
		# save
		$patron->commit;
				
    	# get the terms and suggested resources for this patron
    	my @term_ids;
		my $terms;
		my @suggested_resources;
		foreach ($cgi->param('term_names')) {
    	
    		# get the selected term
    		my $term = MyLibrary::Term->new(name => $_);
    		
    		# save the id and name for future reference
    		push @term_ids, $term->term_id;
    		$terms .= $term->term_name . '; ';
    		
    		# get the suggested resources for this term
    		push @suggested_resources, $term->suggested_resources;
    		
    	}
		
		# "catalog" the patron
		$patron->patron_terms(new => [@term_ids]);
		
		# give them a set of recommended resources
		@suggested_resources = &MyLibrary::Portal::remove_duplicates(@suggested_resources);
		$patron->patron_resources(new => [@suggested_resources]);
		
		# create a list of the resources they have been assigned
		my $resources;
		foreach (@suggested_resources) {
		
			# get the resource
			my $resource = MyLibrary::Resource->new(id => $_);
			$resources .= $resource->name . '; ';
		
		}
		
		# echo the results
		$html .= $cgi->p('Patron created:');
		$html .= $cgi->ul(li('ID -',          $patron->patron_id),
		                  li('First name - ', $patron->patron_firstname),
		                  li('Last name - ',  $patron->patron_surname),
		                  li('Email - ',      $patron->patron_email),
		                  li('Stylesheet - ', $patron->patron_stylesheet_id), 
		                  li('Terms - ',      $terms),
		                  li('Resources - ',  $resources)
		                 );
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All patrons');
	$html .= $cgi->p('This is a list of all the patrons:');
	
	# get all the patrons, build a list, and display it
	my @patrons = MyLibrary::Patron->get_patrons;
	my $patron_list;
	foreach (@patrons) { $patron_list .= $cgi->li($_-> patron_firstname . ' ' . $_->patron_surname, " <span style='color: silver'>(" . $_->patron_id . ')</span>') }
	$html .= $cgi->ol($patron_list);
	
}

sub edit {

	# initialize
	$html = $cgi->h1('Edit patron');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# display a form
		$html .= $cgi->p("Enter the ID of the patron you want to edit. Don't know the ID number? Use <a href='" . $cgi->script_name . "?cmd=find'>find</a>.");
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->textfield(-name => 'id');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'Go');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Go') {
	
    	# create an object based on the input, and create form parts
    	my $patron = MyLibrary::Patron->new(id => $cgi->param('id'));
    	
		# build a list of terms
		my @term_names;
		foreach (MyLibrary::Term->get_terms(sort => 'name')) { push @term_names, $_->term_name }
				
		# build a list of terms for this patron
		my @patron_terms;
		foreach ($patron->patron_terms) {
		
			my $term = MyLibrary::Term->new(id => $_);
			push @patron_terms, $term->term_name;
		
		}

		# display an edit form
		$html .= $cgi->p('Use this form to edit the patron.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $cgi->param('id'));
		$html .= $cgi->table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item',           'Value']),
							td(['ID',              $cgi->param('id')]),
							td(['First name',      $cgi->textfield(-name => 'firstname',  -value => $patron->patron_firstname)]),
							td(['Last name',       $cgi->textfield(-name => 'lastname',   -value => $patron->patron_surname)]),
							td(['Email',           $cgi->textfield(-name => 'email',      -value => $patron->patron_email)]),
							td(['Stylesheet',      $cgi->textfield(-name => 'stylesheet', -value => $patron->patron_stylesheet_id)]),
							td(['Terms',           $cgi->scrolling_list(-name => 'term_names', -values => [@term_names], -defaults => [@patron_terms], -multiple => 'true')]),
							td(['If change, then', "<input type='radio' name='change' value='keep' checked='checked'>Keep</input> <input type='radio' name='change' value='replace'>Replace</input> <input type='radio' name='change' value='merge'>Merge</input>"]),
							td(['',           $cgi->reset(-name   => 'button', -value => 'Reset') . ' ' . $cgi->submit(-name   => 'button',     -value => 'Edit')])

						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    	
	else {
		
		# create a patron object
		my $patron = MyLibrary::Patron->new(id => $cgi->param('id'));
		
		# fill it up with the new data
		$patron->patron_firstname($cgi->param('firstname'));
		$patron->patron_surname($cgi->param('lastname'));
		$patron->patron_email($cgi->param('email'));
		$patron->patron_stylesheet_id($cgi->param('stylesheet'));

		# save
		$patron->commit;
				
		# save the old patron term ids for future reference
		my @old_term_ids = sort($patron->patron_terms);
		
		# save the old patron resources for future reference
		my @old_resource_ids = sort($patron->patron_resources);
		
		# get the new terms for this patron
    	my @term_ids;
		my $terms;
		my @suggested_resources;
		foreach ($cgi->param('term_names')) {
    	
    		my $term = MyLibrary::Term->new(name => $_);
    		push @term_ids, $term->term_id;
    		$terms .= $term->term_name . '; ';
    		
    		# get the suggested resources for this term
    		push @suggested_resources, $term->suggested_resources;

    	}
		
		# delete their old terms and give them the new ones
		$patron->patron_terms(del => [@old_term_ids]);
		my @new_term_ids = sort($patron->patron_terms(new => [@term_ids]));
		
		# compare old term ids to the new term ids
		if (! &MyLibrary::Portal::compare_arrays(\@old_term_ids, \@new_term_ids)) {	
						
			# branch accordingly
			if ($cgi->param('change') eq 'replace') {
			
				# get and delete the patron's current resources in one swoop
				$patron->patron_resources(del => [@old_resource_ids]);
				
				# give them the new suggested resources
				$patron->patron_resources(new => [@suggested_resources]);
				
			}
			
			elsif ($cgi->param('change') eq 'merge') {
			
				# join the old and new lists and remove duplicates; merge
				push @new_term_ids, @old_term_ids;
				@new_term_ids = &MyLibrary::Portal::remove_duplicates(@new_term_ids);
				
				# delete the patron's current resources
				$patron->patron_resources(del => [@old_resource_ids]);
				
				# loop through each new term id
				my @suggested_resources;
				foreach my $term_id (@new_term_ids) {
				
					# create a list of recommended resources for this term
					my $term = MyLibrary::Term->new(id => $term_id);
    				push @suggested_resources, $term->suggested_resources;
				
				}
				
				# remove duplicates and give them the new suggested resources
				@suggested_resources = &MyLibrary::Portal::remove_duplicates(@suggested_resources);
				$patron->patron_resources(new => [@suggested_resources]);
			
			}
		
		}
		
		# create a list of the resources they have been assigned
		my $resources;
		foreach ($patron->patron_resources(sort => 'name')) {
		
			# get the resource
			my $resource = MyLibrary::Resource->new(id => $_);
			$resources .= $resource->name . '; ';
		
		}
		
		# echo the results
		$html .= $cgi->p('Patron created:');
		$html .= $cgi->ul(li('ID -',          $patron->patron_id),
		                  li('First name - ', $patron->patron_firstname),
		                  li('Last name - ',  $patron->patron_surname),
		                  li('Email - ',      $patron->patron_email),
		                  li('Stylesheet - ', $patron->patron_stylesheet_id), 
		                  li('Terms - ',      $terms),
		                  li('Resources - ',  $resources),
		                 );
    
	}
    
}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete patrons');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# display a form
		$html .= $cgi->p("Enter the ID of the resource you want to delete. Don't know the ID number? Use <a href='" . $cgi->script_name . "?cmd=find'>find</a>.");
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->textfield(-name => 'id');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;
		
	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $patron = MyLibrary::Patron->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the patron named <b>' . $patron->patron_firstname . ' ' . $patron->patron_surname  . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $patron->patron_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete it; do the work and echo the result
    	my $patron = MyLibrary::Patron->new(id => $cgi->param('id'));
    	$patron->delete;
    	$html .= $cgi->p('The patron ' . $patron->patron_firstname . ' ' . $patron->patron_surname . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $patron = MyLibrary::Patron->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The patron ' . $patron->patron_firstname . ' ' . $patron->patron_surname . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}

